<?php

namespace App\Http\Controllers\CANTEEN;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Traits\AppMails;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Validation\Rules\Password;

class ForgotPasswordController extends Controller
{
    use AppMails;

    public function showForgetPasswordForm(string $subdomain)
    {
        $canteen = User::where('user_name', $subdomain)->first();
        return view('canteen.auth.forgetPassword', compact('canteen'));
    }

    public function submitForgetPasswordForm(Request $request)
    {

        $request->validate([
            'email' => ['required', 'email', 'max:100', 'exists:users,email'],
        ]);

        $token = Str::random(64);

        DB::table('password_reset_tokens')->insert([
            'email' => $request->email, 
            'token' => $token, 
            'created_at' => Carbon::now()
        ]);

        $user = User::where('email', $request->email)->first();

        $business = User::find($user->main_id);

        $this->am_employee_pass_reset_mail($business, $user, $token);

        \Session::flash("message", "We've emailed your password reset link. Please check your inbox.");

        return response()->json([
            'success' => true,
            'redirect_url' => url('/app/login'),
        ]);

    }

    public function showResetPasswordForm(string $subdomain, $token)
    {
        $canteen = User::where('user_name', $subdomain)->first();
        return view('canteen.auth.forgetPasswordLink', compact('canteen', 'token'));
    }

    public function submitResetPasswordForm(Request $request)
    {

        $request->validate([
            'email' => ['required', 'email', 'max:100', 'exists:users,email'],
            'password' => ['required', 'confirmed', 'regex:/^\S*$/u', Password::min(6)->mixedCase()->numbers()->symbols()],
            'password_confirmation' => 'required'
        ]);

        $tokenData = DB::table('password_reset_tokens')
                        ->where([
                            'email' => $request->email, 
                            'token' => $request->token
                        ])
                        ->first();

        if(!$tokenData){

            \Session::flash("error", "Oops! Something went wrong. Please send request again.");

            return response()->json([
                'success' => true,
                'redirect_url' => url('/app/forgot-password'),
            ]);

        }  

        $tokenCreatedAt = Carbon::parse($tokenData->created_at);
        if ($tokenCreatedAt->diffInMinutes(Carbon::now()) > 30) {

            DB::table('password_reset_tokens')->where(['email' => $request->email])->delete();

            \Session::flash("error", "This reset link has expired. Please request a new one.");
            
            return response()->json([
                'success' => true,
                'redirect_url' => url('/app/forgot-password'),
            ]);
        }

        User::where('email', $request->email)
            ->update(['password' => Hash::make($request->password)]);

        DB::table('password_reset_tokens')->where(['email'=> $request->email])->delete();

        \Session::flash("message", "Your password has been changed successfully.");

        return response()->json([
            'success' => true,
            'redirect_url' => url('/app/login'),
        ]);

    }
}
