<?php

namespace App\Http\Controllers\CANTEEN;

use App\Http\Controllers\Controller;
use App\Models\MembershipPlan;
use App\Models\MembershipSubscription;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;

class MembershipPlanController extends Controller
{
    public function index(){

        $membership_subscription = MembershipSubscription::where('user_main_id', auth()->user()->main_id)->orderBy('id', 'desc')->first();

        return view('canteen.pages.membership.index', compact('membership_subscription'));
    }

    public function planPurchase(string $subdomain, string $planId){

        $membership_plan = MembershipPlan::findOrFail($planId);

        $membership_subscription = new MembershipSubscription();
        $membership_subscription->user_main_id = auth()->user()->main_id;
        $membership_subscription->membership_plan_id = $membership_plan->id;
        $membership_subscription->name = $membership_plan->name;
        $membership_subscription->start_date = Carbon::now()->toDateString();
        $membership_subscription->end_date = Carbon::now()->addDays($membership_plan->duration_days)->toDateString();
        $membership_subscription->permission_ids = $membership_plan->permission_ids;
        $membership_subscription->paid_amount = $membership_plan->total_price;
        $membership_subscription->payment_ref = "Development Test";
        $membership_subscription->payment_at = Carbon::now();
        $membership_subscription->save();

        //Remove Pervious Permissions
        $users = User::where('main_id', auth()->user()->main_id)->get();
        foreach ($users as $user) {
            $user->permissions()->sync([]);
        }

        // Attach Membership permissions to Canteens
        $user = User::find($membership_subscription->user_main_id);
        $user->permissions()->sync($membership_subscription->permission_ids);

        \Session::flash("message", "Membership purchase successful");

        return redirect()->to('/app/membership-plans');

    }

}
