<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Kyslik\ColumnSortable\Sortable;

class ItemBadge extends Model
{
    use SoftDeletes, Sortable;

    public function user(){
        return $this->belongsTo('app\Models\User', 'user_main_id');
    }

    public $sortable = [
        'id',
        'uid',
        'user_main_id',
        'name',
        'position',
        'is_active',
        'created_at',
        'updated_at'
    ];

}
