<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Kyslik\ColumnSortable\Sortable;

class Order extends Model
{
    use SoftDeletes, Sortable;

    public $sortable = [
        'id',
        'uid',
        'created_at',
        'updated_at'
    ];

    protected function casts(): array
    {
        return [
            'ordered_at' => 'datetime',
        ];
    }


    public function customer(){
        return $this->belongsTo('App\Models\Customer', 'customer_id');
    }

    public function order_items(){
        return $this->hasMany('App\Models\OrderItem', 'order_id');
    }

    public function order_status(){
        return $this->belongsTo('App\Models\OrderStatus', 'order_status_id');
    }

    public function payment_method(){
        return $this->belongsTo('App\Models\PaymentMethod', 'payment_method_id');
    }

    public function payment_status(){
        return $this->belongsTo('App\Models\PaymentStatus', 'payment_status_id');
    }


}
