<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Kyslik\ColumnSortable\Sortable;

class Tax extends Model
{
    use SoftDeletes, Sortable;

    public function user(){
        return $this->belongsTo('app\Models\User', 'user_main_id');
    }

    protected $fillable = [
        'uid',
        'user_main_id',
        'name',
        'type',
        'value',
        'position',
        'is_active',
    ];

}
