<?php

namespace App\Traits;

use App\Models\User;
use Illuminate\Support\Facades\Mail;

trait AppMails
{
    private function sendMail(array $toEmails, string $subject, $htmlBody){
        try {
            Mail::html($htmlBody, function($message) use($subject, $toEmails) {
                $message
                // ->from($mail_from_address, $mailFrom)
                ->subject($subject)
                ->to($toEmails);
            });
        } catch(\Exception $e) {
            $error = $e->getMessage();
            dd($error, 'Hello');
        }
    }

    public function am_otp_mail($business, $mailTo, $otp){

        $subject = "Account Verification – ".config('app.name');

        $templateHtml = file_get_contents(base_path()."/resources/emails/otp.html");
        $templateHtml = str_replace('[otp]', $otp, $templateHtml);
        $templateHtml = str_replace('[app_name]', config('app.name'), $templateHtml);
        $templateHtml = str_replace('[year]', date('Y'), $templateHtml);

        $this->sendMail([$mailTo], $subject, $templateHtml);

    }

    public function am_employee_welcome_mail($business, $employee, $password){

        $business = User::find(auth()->user()->main_id);

        $subject = "Welcome to ".$business->business_name;

        $templateHtml = file_get_contents(base_path()."/resources/emails/employee_welcome.html");

        $templateHtml = str_replace('[name]', $employee->name, $templateHtml);
        $templateHtml = str_replace('[email]', $employee->email, $templateHtml);
        $templateHtml = str_replace('[password]', $password, $templateHtml);
        $templateHtml = str_replace('[login_url]', url('/app/login'), $templateHtml);
        
        $templateHtml = str_replace('[app_logo]', asset($business->logo), $templateHtml);
        $templateHtml = str_replace('[business_name]', $business->business_name, $templateHtml);
        $templateHtml = str_replace('[app_name]', config('app.name'), $templateHtml);
        $templateHtml = str_replace('[year]', date('Y'), $templateHtml);

        $this->sendMail([$employee->email], $subject, $templateHtml);

    }

    public function am_employee_pass_reset_mail($business, $user, $token){

        $business = User::find($user->main_id);

        $subject = "Reset Password - ".$business->business_name;

        $templateHtml = file_get_contents(base_path()."/resources/emails/employee_password_reset.html");

        $templateHtml = str_replace('[name]', $user->name, $templateHtml);
        $templateHtml = str_replace('[reset_link]', url('/app/reset-password', [$token]), $templateHtml);
        
        $templateHtml = str_replace('[app_logo]', asset($business->logo), $templateHtml);
        $templateHtml = str_replace('[business_name]', $business->business_name, $templateHtml);
        $templateHtml = str_replace('[app_name]', config('app.name'), $templateHtml);
        $templateHtml = str_replace('[year]', date('Y'), $templateHtml);

        $this->sendMail([$user->email], $subject, $templateHtml);

    }

}
