<?php

namespace App\Traits;

use Google\Client as GoogleClient;

trait FCMNotification
{
    
    public function fcm_test_notification(array $tokens, $title, $body){
        $this->fcm_send_notification($tokens, $title, $body);
    }

    private function fcm_send_notification(array $tokens, string $title, string $body){
        try {

            $credentialsFilePath = base_path()."/json/therpos-firebase-adminsdk-fbsvc-2eb12579b9.json";
            $client = new GoogleClient();
            $client->setAuthConfig($credentialsFilePath);
            $client->addScope('https://www.googleapis.com/auth/firebase.messaging');
            $token = $client->fetchAccessTokenWithAssertion();
            $access_token = $token['access_token'];

            foreach ($tokens as $token) {

                $headers = [
                    "Authorization: Bearer ".$access_token,
                    'Content-Type: application/json'
                ];
        
                $data = [
                    "message" => [
                        "token" => $token,
                        "data" => [
                            "body" => $body,
                            "title" => $title,
                            "icon" => "/icon.png",
                        ],
                        "android" => [
                            "notification" => [
                                "sound" => "ding"
                            ]
                        ],
                        "apns" => [
                            "payload" => [
                                "aps" => [
                                    "sound" => "ding"
                                ]

                            ]
                        ]    
                    ]
                ];

                $payload = json_encode($data);
        
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/therpos/messages:send");
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
                curl_setopt($ch, CURLOPT_VERBOSE, true);
                $response = curl_exec($ch);
                $err = curl_error($ch);
                curl_close($ch);

            }
            
        } catch (\Throwable $th) {
            throw $th;
        }
    }

}
