<?php

namespace App\Traits;

trait FileUpload
{
    public function uploadFile($file, $folderName){

        try {
            $file_name = uniqid().date('d').'.'.$file->extension();
            $file->move(public_path('uploads/'.$folderName.'/'), $file_name);
            return [
                'success' => true,
                'data' => '/uploads/'.$folderName.'/'.$file_name,
            ];
        } catch (\Exception $e) {
            return [
                'success' => false,
                'data' => $e->getMessage(),
            ];
        }
    
    }

    public function deleteFile($fileURL){

        if(empty($fileURL)){
            return true;
        }

        $filePath = public_path().$fileURL;

        if(is_dir($filePath)){
            return true;
        }

        if(file_exists($filePath)){
            unlink($filePath);
        }
    }

}
