<?php

namespace App\Traits;

use App\Models\Item;
use App\Models\ItemAddon;
use App\Models\Order;
use App\Models\OrderItem;
use App\Models\OrderItemAddon;
use App\Models\OrderItemTax;
use App\Models\Tax;
use Illuminate\Support\Facades\DB;

trait OrderUtils
{
    use InsertOrderPayment;

    public function ou_store_order(object $reqOrderObj){

        $orderId = DB::transaction(function() use($reqOrderObj){

            //Order Init
            $order = new Order();
            $order->user_main_id = $reqOrderObj->main_id;
            $order->currency = $reqOrderObj->currency;
            $order->customer_id = $reqOrderObj->customer_id;
            $order->ordered_at = $reqOrderObj->ordered_at;
            $order->restaurant_instruction = $reqOrderObj->restaurant_instruction;
            $order->need_cutlery = $reqOrderObj->need_cutlery;
            $order->order_status_id = $reqOrderObj->order_status_id;
            $order->payment_method_id = $reqOrderObj->payment_method_id;
            $order->payment_status_id = $reqOrderObj->payment_status_id;
            $order->order_placed_by = $reqOrderObj->order_placed_by;

            //---------------------------------------
            $order->subtotal_amount = 0;
            $order->discount_amount = 0;
            $order->net_amount = 0;
            $order->tax_amount = 0;
            $order->tip_amount = 0;
            $order->payable_amount = 0;
            $order->save();

            //Order Item
            foreach ($reqOrderObj->cartItem as $cartItem) {
                
                $item = Item::find($cartItem["item_id"]);
                if(!empty($item->item_id)){
                    $mainItem = Item::find($item->item_id);
                    if(!empty($mainItem)){
                        $item->name = $mainItem->name." (".$item->name.")";
                    }
                }

                $orderItem = new OrderItem();
                $orderItem->user_main_id = $order->user_main_id;

                $orderItem->order_id = $order->id;
                $orderItem->item_id = $item->id;
                $orderItem->item_name = $item->name;
                $orderItem->item_price = $item->price;
                $orderItem->qty = $cartItem["quantity"];

                //--------------------------------------
                $orderItem->addon_price = 0;
                $orderItem->sub_total = 0;
                $orderItem->discount = 0;
                $orderItem->net_amount = 0;
                $orderItem->tax_amount = 0;
                $orderItem->payable_amount = 0;
                $orderItem->save();
                
                //Item Addons
                if(isset($cartItem["addons"]) && is_array($cartItem["addons"])){

                    foreach ($cartItem["addons"] as $cartItemAddon) {

                        $addon = ItemAddon::find($cartItemAddon["addon_id"]);

                        $orderItemAddon = new OrderItemAddon();
                        $orderItemAddon->order_id = $order->id;
                        $orderItemAddon->order_item_id = $orderItem->id;

                        $orderItemAddon->item_addon_id = $addon->id;
                        $orderItemAddon->addon_name = $addon->name;
                        $orderItemAddon->addon_price = $addon->price;

                        $orderItemAddon->addon_qty = $cartItemAddon["qty"];
                        $orderItemAddon->sub_total = ($orderItemAddon->addon_price * $orderItemAddon->addon_qty);
                        $orderItemAddon->save();
                    
                    }

                    $orderItem->addon_price = OrderItemAddon::where('order_id', $order->id)->where('order_item_id', $orderItem->id)->sum('sub_total');
                }

                $orderItem->sub_total = ($orderItem->item_price * $orderItem->qty) + $orderItem->addon_price;
                $orderItem->discount = $cartItem["discount"];
                $orderItem->net_amount = ($orderItem->sub_total - $orderItem->discount);

                //Item Taxes
                if(is_array($item->tax_ids) && count($item->tax_ids) > 0){

                    $itemTaxes = Tax::find($item->tax_ids);

                    foreach ($itemTaxes as $itemTax) {
                       
                        $orderItemTax = new OrderItemTax();
                        $orderItemTax->order_id = $order->id;
                        $orderItemTax->tax_id = $itemTax->id;
                        $orderItemTax->order_item_id = $orderItem->id;
                        $orderItemTax->tax_name = $itemTax->name;
                        $orderItemTax->tax_type = $itemTax->type;
                        $orderItemTax->tax_value = $itemTax->value;

                        if($itemTax->type == "percentage"){
                            $orderItemTaxAmount = ($itemTax->value / 100) * $orderItem->net_amount;
                        }else{
                            $orderItemTaxAmount = $itemTax->value * $orderItem->qty;
                        }

                        $orderItemTax->item_tax_amount = $orderItemTaxAmount;
                        $orderItemTax->save();

                    }

                    $orderItem->tax_amount = OrderItemTax::where('order_id', $order->id)->where('order_item_id', $orderItem->id)->sum('item_tax_amount');
                }

                $orderItem->payable_amount = $orderItem->net_amount + $orderItem->tax_amount;
                $orderItem->instructions = $cartItem["instructions"];
                $orderItem->save();

            }

            $orderItems = OrderItem::where('order_id', $order->id)->get();

            $order->subtotal_amount = $orderItems->sum('sub_total');
            $order->discount_amount = $orderItems->sum('discount');
            $order->net_amount = $orderItems->sum('net_amount');
            $order->tax_amount = $orderItems->sum('tax_amount');
            $order->tip_amount = 0;
            $order->payable_amount = $orderItems->sum('payable_amount');
            $order->save();

            if($order->payment_status_id == 2){
                $this->iop_insert_payment($order);
            }

            return $order->id;

        });

        return [
            "order_id" => $orderId,
        ];

    }

    public function ou_update_order(object $reqOrderObj){

        $orderId = DB::transaction(function() use($reqOrderObj){

            //Order Init
            $order = Order::find($reqOrderObj->order_id);

            //Store Old Payment Status
            $old_payment_status = $order->payment_status_id;

            $order->restaurant_instruction = $reqOrderObj->restaurant_instruction;
            $order->payment_method_id = $reqOrderObj->payment_method_id;
            $order->payment_status_id = $reqOrderObj->payment_status_id;
            $order->order_status_id = $reqOrderObj->order_status_id;
            $order->need_cutlery = $reqOrderObj->need_cutlery;
            $order->save();

            //-------------------------------------------
            // Delete Removed Order Items
            $allOrderItemIds = array_column($reqOrderObj->cartItem, 'item_id');

            $removed_order_item_count = OrderItem::where('order_id', $order->id)->whereNotIn('item_id', $allOrderItemIds)->count();
            if($removed_order_item_count > 0){
                OrderItem::where('order_id', $order->id)->whereNotIn('item_id', $allOrderItemIds)->delete();
            }

            //-------------------------------------------
            // Delete Removed Order Items Addons
            $allOrderAddonIds = array_merge(
                ...array_map(function ($item) {
                    return array_column($item['addons'], 'addon_id');
                }, $reqOrderObj->cartItem)
            );

            $removed_addon_count = OrderItemAddon::where('order_id', $order->id)->whereNotIn('item_addon_id', $allOrderAddonIds)->count();
            if($removed_addon_count > 0){
                OrderItemAddon::where('order_id', $order->id)->whereNotIn('item_addon_id', $allOrderAddonIds)->delete();
            }

            //--------------------------------------------
            // Delete Removed Order Items Taxes
            $allOrderItemTableIds = OrderItem::selectRaw('id')->where('order_id', $order->id)->get()->pluck('id')->toArray();

            $removed_order_item_count_tax_count = OrderItemTax::where('order_id', $order->id)->whereNotIn('order_item_id', $allOrderItemTableIds)->count();
            if($removed_order_item_count_tax_count > 0){
                OrderItemTax::where('order_id', $order->id)->whereNotIn('order_item_id', $allOrderItemTableIds)->delete();
            }

            //----------------------------------
            // Insert Or Update Order Item
            foreach ($reqOrderObj->cartItem as $cartItem) {
                
                $item = Item::find($cartItem["item_id"]);
                if(!empty($item->item_id)){
                    $mainItem = Item::find($item->item_id);
                    if(!empty($mainItem)){
                        $item->name = $mainItem->name." (".$item->name.")";
                    }
                }
                
                if(isset($cartItem["id"])){
                    $orderItem = OrderItem::find($cartItem["id"]);
                }else{
                    $orderItem = new OrderItem();
                }

                $orderItem = OrderItem::firstOrNew([
                    'order_id' => $order->id,
                    'item_id' => $item->id,
                ]);

                $orderItem->user_main_id = $order->user_main_id;
                $orderItem->order_id = $order->id;
                $orderItem->item_name = $item->name;
                $orderItem->item_id = $item->id;
                $orderItem->item_price = $item->price;
                
                $orderItem->qty = $cartItem["quantity"];

                //--------------------------------------
                $orderItem->addon_price = 0;
                $orderItem->sub_total = 0;
                $orderItem->discount = 0;
                $orderItem->net_amount = 0;
                $orderItem->tax_amount = 0;
                $orderItem->payable_amount = 0;
                $orderItem->save();

                //---------------------------------
                // Item Addons
                if(isset($cartItem["addons"]) && is_array($cartItem["addons"])){

                    foreach ($cartItem["addons"] as $cartItemAddon) {

                        $orderItemAddon = OrderItemAddon::where('order_item_id', $orderItem->id)->where('item_addon_id', $cartItemAddon["addon_id"])->firstOrNew();
                        $addon = ItemAddon::find($cartItemAddon["addon_id"]);

                        $orderItemAddon->order_id = $order->id;
                        $orderItemAddon->order_item_id = $orderItem->id;

                        $orderItemAddon->item_addon_id = $addon->id;
                        $orderItemAddon->addon_name = $addon->name;
                        $orderItemAddon->addon_price = $addon->price;

                        $orderItemAddon->addon_qty = $cartItemAddon["qty"];
                        $orderItemAddon->sub_total = ($orderItemAddon->addon_price * $orderItemAddon->addon_qty);
                        $orderItemAddon->save();
                    
                    }

                    $orderItem->addon_price = OrderItemAddon::where('order_id', $order->id)->where('order_item_id', $orderItem->id)->sum('sub_total');
                }

                $orderItem->sub_total = ($orderItem->item_price * $orderItem->qty) + $orderItem->addon_price;
                $orderItem->discount = $cartItem["discount"];
                $orderItem->net_amount = ($orderItem->sub_total - $orderItem->discount);

                //--------------------------------------
                // Delete Taxes Which Removed From Item
                $order_item_tax_ids = OrderItemTax::where('order_item_id', $orderItem->id)->pluck('tax_id')->toArray();
                if(count($order_item_tax_ids) > 0){
                    $removed_tax_from_item_ids = array_diff($order_item_tax_ids, $item->tax_ids);
                    if(count($removed_tax_from_item_ids) > 0){
                        OrderItemTax::where('order_item_id', $orderItem->id)->whereIn('tax_id', $removed_tax_from_item_ids)->delete();
                    }
                }

                //---------------------------------
                // Item Taxes
                if(is_array($item->tax_ids) && count($item->tax_ids) > 0){

                    $itemTaxes = Tax::find($item->tax_ids);

                    foreach ($itemTaxes as $itemTax) {

                        $orderItemTax = OrderItemTax::firstOrNew([
                            'order_id' => $order->id,
                            'tax_id' => $itemTax->id,
                            'order_item_id' => $orderItem->id,
                        ]);

                        $orderItemTax->order_id = $order->id;
                        $orderItemTax->tax_id = $itemTax->id;
                        $orderItemTax->order_item_id = $orderItem->id;
                        $orderItemTax->tax_name = $itemTax->name;
                        $orderItemTax->tax_type = $itemTax->type;
                        $orderItemTax->tax_value = $itemTax->value;

                        if($itemTax->type == "percentage"){
                            $orderItemTaxAmount = ($itemTax->value / 100) * $orderItem->net_amount;
                        }else{
                            $orderItemTaxAmount = $itemTax->value * $orderItem->qty;
                        }

                        $orderItemTax->item_tax_amount = $orderItemTaxAmount;
                        $orderItemTax->save();

                    }

                    $orderItem->tax_amount = OrderItemTax::where('order_id', $order->id)->where('order_item_id', $orderItem->id)->sum('item_tax_amount');
                }

                $orderItem->payable_amount = $orderItem->net_amount + $orderItem->tax_amount;
                $orderItem->instructions = $cartItem["instructions"];
                $orderItem->save();

            }

            $orderItems = OrderItem::where('order_id', $order->id)->get();

            $order->subtotal_amount = $orderItems->sum('sub_total');
            $order->discount_amount = $orderItems->sum('discount');
            $order->net_amount = $orderItems->sum('net_amount');
            $order->tax_amount = $orderItems->sum('tax_amount');
            $order->tip_amount = 0;
            $order->payable_amount = $orderItems->sum('payable_amount');
            $order->save();

            if($old_payment_status == 1 && $order->payment_status_id == 2){
                $this->iop_insert_payment($order);
            }

            return $order->id;

        });

        return [
            "success" => true,
            "order_id" => $orderId,
        ];

    }
    
}
