<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Illuminate\Auth\AuthenticationException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->append([
            App\Http\Middleware\SetAppDomain::class,
        ])
        ->alias([
            'permission' => \Spatie\Permission\Middleware\PermissionMiddleware::class,
        ]);
        
        // $middleware->redirectUsersTo(function(Request $request) {
        //     return $request->user()->isAdmin() ? '/admin' : '/home';
        // });

        $middleware->redirectGuestsTo(function(Request $request) {
            if (count(explode('.', $request->getHost())) === 3) {    
                if (($request->is('app') || $request->is('app/*')) && !$request->is('app/login')) {
                    return 'app/login';
                }
            }
            return '/login';
        });
    })
    ->withExceptions(function (Exceptions $exceptions) {

    })->create();
