<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('items', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('uid');
            $table->bigInteger('user_main_id')->unsigned();
            $table->string('name', 100);
            $table->text('description')->nullable();
            $table->json('category_ids')->nullable();
            $table->string('currency', 3);
            $table->decimal('price', 8,2)->default(0);
            $table->bigInteger('stock_quantity')->nullable();
            $table->string('image')->default('/images/default/item.png');
            $table->text('ingredients')->nullable();
            $table->text('allergen_info')->nullable();
            $table->json('tax_ids')->nullable();
            $table->decimal('tax', 8,2)->default(0);
            $table->unsignedBigInteger('position')->nullable();
            $table->boolean('is_active')->default(1);
            $table->boolean('has_variant')->default(0);
            $table->bigInteger('item_id')->nullable();
            $table->timestamps();
            $table->softDeletes();
            
            $table->json('badge_ids')->nullable();
            $table->bigInteger('unit_id')->unsigned()->nullable();
            $table->date('expiry_date')->nullable();

            // foreign key
            $table->foreign('user_main_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('items');
    }
};
