<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Create the trigger
        DB::statement('
            CREATE TRIGGER create_items_uid
            BEFORE INSERT ON items
            FOR EACH ROW
            BEGIN
                DECLARE last_uid INT;
                SET last_uid = (
                    SELECT COALESCE(MAX(uid), 0)
                    FROM items
                    WHERE user_main_id = NEW.user_main_id
                );
                SET NEW.uid = last_uid + 1;
            END
        ');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Schema::dropIfExists('trigger_insert_items_uid');
    }
};
