<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('item_badges', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('uid')->unsigned();
            $table->bigInteger('user_main_id')->unsigned();
            $table->string('name', 100);
            $table->string('image');
            $table->boolean('is_active')->default(1);
            $table->unsignedBigInteger('position')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('item_badges');
    }
};
