<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('units', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('uid');
            $table->bigInteger('user_main_id')->unsigned();

            $table->string('name', 100);
            $table->string('symbol', 32);
            $table->text('description')->nullable();

            $table->timestamps();
            $table->softDeletes();

            // foreign key
            $table->foreign('user_main_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('units');
    }
};
