<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('uid');
            $table->bigInteger('user_main_id')->unsigned();

            $table->string('currency', 3);
            $table->unsignedBigInteger('customer_id')->nullable();
            $table->timestamp('ordered_at');
            $table->text('restaurant_instruction')->nullable();

            $table->boolean('need_cutlery')->default(0);

            $table->decimal('subtotal_amount', 8,2)->default(0);
            $table->decimal('discount_amount', 8,2)->default(0);
            $table->decimal('net_amount', 8,2)->default(0);
            $table->decimal('tax_amount', 8,2)->default(0);
            $table->decimal('tip_amount', 8,2)->default(0);
            $table->decimal('payable_amount', 8,2)->default(0);

            $table->unsignedBigInteger('order_status_id');
            $table->unsignedBigInteger('payment_method_id');
            $table->unsignedBigInteger('payment_status_id');

            $table->unsignedBigInteger('order_placed_by');

            $table->timestamps();
            $table->softDeletes();

            // foreign key
            $table->foreign('user_main_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('customer_id')->references('id')->on('customers')->onDelete('cascade');
            
            $table->foreign('order_status_id')->references('id')->on('order_statuses');
            $table->foreign('payment_method_id')->references('id')->on('payment_methods');
            $table->foreign('payment_status_id')->references('id')->on('payment_statuses');
            
            $table->foreign('order_placed_by')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
