<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('order_items', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_main_id');
            $table->unsignedBigInteger('order_id');
            $table->unsignedBigInteger('item_id');
            $table->string('item_name', 100)->nullable();
            $table->decimal('item_price', 8,2);
            $table->decimal('addon_price', 8,2)->default(0);
            $table->integer('qty');
            $table->decimal('sub_total', 8,2);
            $table->decimal('discount')->default(0);
            $table->decimal('net_amount');
            $table->decimal('tax_amount', 8,2)->default(0);;
            $table->decimal('payable_amount', 8,2);
            $table->text('instructions')->nullable();
            $table->timestamps();
            $table->softDeletes();

            // foreign key
            $table->foreign('user_main_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('order_id')->references('id')->on('orders')->onDelete('cascade');
            $table->foreign('item_id')->references('id')->on('items')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('order_items');
    }
};
