<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('membership_subscriptions', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('user_main_id')->unsigned();

            $table->bigInteger('membership_plan_id')->unsigned();
            $table->string('name', 100);
            $table->date('start_date')->default(now());
            $table->date('end_date')->default(now());
            $table->json('permission_ids');

            $table->decimal('paid_amount', 10,2)->default(0);
            $table->string('payment_ref')->nullable();
            $table->timestamp('payment_at')->default(now());

            $table->timestamps();
            $table->softDeletes();

            // foreign key
            $table->foreign('user_main_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('membership_plan_id')->references('id')->on('membership_plans')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('membership_subscriptions');
    }
};
