@extends('canteen.layouts.app')

@section('page-title')
    Orders
@endsection

@section('page.content')

    <!-- Page header -->
    <div class="page-header">
        <div class="container-xl">
            <div class="row align-items-center mw-100">
                <div class="col">
                    <h2 class="page-title">
                        Orders
                    </h2>
                </div>
                <div class="col-auto">
                    <div class="d-flex">
                        <div class="me-3 d-none d-md-block">
                            <form action="">
                                <div class="input-group">
                                    <input type="text" name="query" class="form-control" placeholder="Search..." value="{{ request()->query('query') }}">
                                    <button class="btn" type="submit">
                                        <svg class="me-0" xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-search" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                            <path d="M10 10m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0"></path>
                                            <path d="M21 21l-6 -6"></path>
                                        </svg>
                                    </button>
                                </div>
                            </form>
                        </div>

                        @can('orders.create')
                            <a href="{{ url('/app/pos') }}" class="btn btn-primary">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-plus" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path d="M12 5l0 14"></path>
                                    <path d="M5 12l14 0"></path>
                                </svg>
                                Add New
                            </a>
                        @endcan

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Page body -->
    <div class="page-body">
        <div class="container-xl">

            <div class="row row-cards">
                <div class="col-12">
                    <div class="card">
                
                        <div class="table-responsive min-h-500">
                            <table class="table card-table table-vcenter text-nowrap">
                                <thead>
                                    <tr>
                                        <th class="w-1">@sortablelink('uid', 'ID.')</th>
                                        <th>@sortablelink('ordered_at', 'Ordered At')</th>
                                        <th>@sortablelink('customer.name', 'Customer')</th>

                                        {{-- <th>@sortablelink('subtotal_amount', 'Subtotal')</th>
                                        <th>@sortablelink('discount_amount', 'Discount')</th>
                                        <th>@sortablelink('net_amount', 'Net Amount')</th>
                                        <th>@sortablelink('tax_amount', 'Tax')</th> --}}

                                        <th>@sortablelink('payable_amount', 'Payable Amount')</th>
                                        <th>@sortablelink('order_status.name', 'Order Status')</th>
                                        <th>@sortablelink('payment_method.name', 'Payment Method')</th>
                                        <th>@sortablelink('payment_status.name', 'Payment Status')</th>

                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @if ($rows->total() === 0)
                                        <tr>
                                            <td class="text-center" colspan="21">No records available to display.</td>
                                        </tr>
                                    @endif

                                    @foreach ($rows as $row)
                                        <tr>
                                            <td>
                                                <span class="text-secondary">{{ $row->uid }}</span>
                                            </td>
                                            <td>{{ date_format($row->ordered_at, setting('date_time_format')) }}</td>
                                            <td>{{ isset($row->customer->name) ? $row->customer->name : "Guest" }}</td>
                                            <td>{{ $row->payable_amount }}</td>
                                            <td>
                                                <span class="badge os-{{ Str::slug($row->order_status->name) }}">{{ $row->order_status->name }}</span>
                                            </td>
                                            <td>
                                                <span class="badge pm-{{ Str::slug($row->payment_method->name) }}">{{ $row->payment_method->name }}</span>
                                            </td>
                                            <td>
                                                <span class="badge {{ Str::slug($row->payment_status->name) }}">{{ $row->payment_status->name }}</span>
                                            </td>

                                            @can('orders.update')
                                                <td class="text-end">
                                                    <div class="dropdown">
                                                        <button class="btn dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                            Action
                                                        </button>
                                                        <ul class="dropdown-menu dropdown-menu-start">
                                                            <li>
                                                                <a class="dropdown-item" href="{{ url('/app/orders/'.$row->id.'/edit') }}">
                                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon dropdown-item-icon icon-2"><path d="M7 7h-1a2 2 0 0 0 -2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2 -2v-1"></path><path d="M20.385 6.585a2.1 2.1 0 0 0 -2.97 -2.97l-8.415 8.385v3h3l8.385 -8.415z"></path><path d="M16 5l3 3"></path></svg>
                                                                    Edit
                                                                </a>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </td> 
                                            @endcan

                                        </tr>
                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                        
                        {{ $rows->appends(request()->except('page'))->links() }}

                    </div>
                </div>
            </div>
            
        </div>
    </div>

@endsection

@section('page.css')
    <style>

        /* Payment Status */
        .pending {
            color: color-mix(in srgb, var(--tblr-yellow) calc(var(--tblr-text-opacity, 1) * 100%), transparent) !important;
            background-color:  color-mix(in srgb, var(--tblr-yellow-lt) calc(var(--tblr-bg-opacity, 1) * 100%), transparent) !important;
        }
        .paid {
            color: color-mix(in srgb, var(--tblr-lime) calc(var(--tblr-text-opacity, 1) * 100%), transparent) !important;
            background-color:  color-mix(in srgb, var(--tblr-lime-lt) calc(var(--tblr-bg-opacity, 1) * 100%), transparent) !important;
        }

        /* Order Status */
        .os-pending{
            background-color: color-mix(in srgb, var(--tblr-yellow) calc(var(--tblr-bg-opacity, 1) * 100%), transparent) !important;
            color: var(--tblr-blue-fg) !important;
        }
        .os-in-progress{
            background-color: color-mix(in srgb, var(--tblr-blue) calc(var(--tblr-bg-opacity, 1) * 100%), transparent) !important;
            color: var(--tblr-blue-fg) !important;
        }
        .os-ready{
            background-color: color-mix(in srgb, var(--tblr-teal) calc(var(--tblr-bg-opacity, 1) * 100%), transparent) !important;
            color: var(--tblr-blue-fg) !important;
        }
        .os-completed{
            background-color: color-mix(in srgb, var(--tblr-green) calc(var(--tblr-bg-opacity, 1) * 100%), transparent) !important;
            color: var(--tblr-blue-fg) !important;
        }
        .os-cancelled{
            background-color: color-mix(in srgb, var(--tblr-red) calc(var(--tblr-bg-opacity, 1) * 100%), transparent) !important;
            color: var(--tblr-blue-fg) !important;
        }

        /* Payment Method */
        .pm-cash{
            color: color-mix(in srgb, var(--tblr-green) calc(var(--tblr-text-opacity, 1) * 100%), transparent) !important;
            background-color:  color-mix(in srgb, var(--tblr-green-lt) calc(var(--tblr-bg-opacity, 1) * 100%), transparent) !important;
        }
        .pm-pay-online{
            color: color-mix(in srgb, var(--tblr-blue) calc(var(--tblr-text-opacity, 1) * 100%), transparent) !important;
            background-color:  color-mix(in srgb, var(--tblr-blue-lt) calc(var(--tblr-bg-opacity, 1) * 100%), transparent) !important;
        }
        .pm-qr-code{
            color: color-mix(in srgb, var(--tblr-purple) calc(var(--tblr-text-opacity, 1) * 100%), transparent) !important;
            background-color:  color-mix(in srgb, var(--tblr-purple-lt) calc(var(--tblr-bg-opacity, 1) * 100%), transparent) !important;
        }
    </style>
@endsection