<div class="row mb-3">

   <input type="hidden" id="data-itemId" value="{{ $item->id }}"> 
   <input type="hidden" id="data-itemName" value="{{ $item->name }}"> 
   <input type="hidden" id="data-itemQuantity" value="{{ $item->stock_quantity }}"> 
   <input type="hidden" id="data-itemPrice" value="{{ $item->price }}"> 
   <input type="hidden" id="data-itemTaxIds" value="@json($item->tax_ids)"> 
   <input type="hidden" id="data-addonsCount" value="{{ $item->addon_count }}"> 

    <div class="col-4 text-center">
        <img class="img-responsive-1x1 rounded-3 border" src="{{ asset($item->image) }}" alt="{{ $item->name }}">

        @if ($item->badges->isNotEmpty() && count($item->badges) > 0)
        <div class="popup-item-badges-warp">
            @foreach ($item->badges as $badge)
                <img src="{{ asset($badge->image) }}" alt="{{ $badge->name }}">
            @endforeach
        </div>
        @endif
    </div>
    <div class="col-8">
        <div class="name-allergen-warp">
            <h2 id="pop-up-item-name">
                {{ $item->name }}
                @if (!empty($item->allergen_info))
                    <span class="ms-2 text-yellow allergen-icon">
                        <svg class="me-0" xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round" ><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0" /><path d="M12 8v4" /><path d="M12 16h.01" /></svg>
                    </span>
                @endif
            </h2>
            <div id="allergen-tooltip" class="bg-yellow-lt text-dark">{{ $item->allergen_info }}</div>
        </div>
        <p>{{ $item->description }}</p>
        @if (!empty($item->taxes) && count($item->taxes) > 0)
        <h4 class="mb-1">Taxes</h4>
        <p>
            @foreach ($item->taxes as $tax)
                @if ($tax->type == 'fixed')
                    <span class="badge badge-outline text-yellow">{{ $tax->name }} ({{ $item->currency }} {{ $tax->value }})</span>            
                @else
                    <span class="badge badge-outline text-yellow">{{ $tax->name }} ({{ $tax->value }}%)</span>            
                @endif
            @endforeach
        </p>
        @endif

        @if (empty($item->variants) || count($item->variants) == 0)
        <h3>
            {{ $item->currency }} {{ $item->price }}</h3>
        @endif

        <div class="pop-up-qty-warp">
            <div class="input-group">
                <button class="btn pop-up-cart-qty-minus text-lime" type="button">
                    <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon me-0 icon-tabler icons-tabler-outline icon-tabler-circle-minus"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0" /><path d="M9 12l6 0" /></svg>
                </button>
                <input type="number" class="form-control" id="pop-up-cart-qty" value="1" min="1">
                <button class="btn pop-up-cart-qty-plus text-lime" type="button">
                    <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon me-0 icon-tabler icons-tabler-outline icon-tabler-circle-plus"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0" /><path d="M9 12h6" /><path d="M12 9v6" /></svg>
                </button>
            </div>
        </div>
    </div>
</div>

@if (!empty($item->variants) && count($item->variants) > 0)
<div class="row mt-2">
    <div class="col-12">

        <div class="mb-1">
            <h3 class="mb-2">Size</h3>
            <div class="">
                <div class="pop-up-size-item-warp row">

                    @foreach ($item->variants as $variant)
                        <div class="col-6 col-md-4 col-lg-3">
                            <label class="form-check d-flex align-items-center">
                                <div>
                                    <input class="form-check-input" type="radio" data-variant-name="{{ $variant->name }}" data-variant-price="{{ $variant->price }}" name="variant_id" value="{{  $variant->id }}">
                                </div>
                                <div class="">
                                    <span class="form-check-label fw-bold">{{ $variant->name }}</span>
                                    <span>{{ $item->currency }} {{ $variant->price }}</span>
                                </div>
                            </label>
                        </div>
                    @endforeach

                </div>
            </div>
        </div>

    </div>
</div>    
@endif

@if (!empty($item->addons) && count($item->addons) > 0)
<div class="row mt-2">
    <div class="col-12">
        <h3 class="mb-2">Addons</h3>
    </div>

    @foreach ($item->addons as $addon)
        <div class="col-12 col-md-6 mb-2">
            <label class="form-selectgroup-item flex-fill">
                <input type="checkbox" name="addon_id[]" data-addon-name="{{ $addon->name }}" data-addon-price="{{ $addon->price }}" value="{{ $addon->id }}" class="form-selectgroup-input pop-up-addon" {{ ($addon->is_required == 1) ? "checked" : "" }} @if($addon->is_required == 1) onclick="return false;" @endif>
                <div class="form-selectgroup-label d-flex align-items-center">
                    <div class="me-3">
                        <span class="form-selectgroup-check"></span>
                    </div>
                    <div class="form-selectgroup-label-content d-flex align-items-center">
                        <span class="avatar avatar-2 me-3" style="background-image: url({{ asset($addon->image) }})"></span>
                        <div>
                            @if($addon->is_required == 1) <span class="pos-required-addon">*</span> @endif
                            <div class="font-weight-medium text-start text-truncate">{{ $addon->name }}</div>
                            <div class="text-secondary text-start">{{ $item->currency }} {{ $addon->price }}</div>
                        </div>
                    </div>
                </div>
            </label>

            <div class="pop-up-addon-qty-warp">
                <div class="input-group">
                    <button class="btn pop-up-addon-cart-qty-minus text-lime" type="button">
                        <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon me-0 icon-tabler icons-tabler-outline icon-tabler-circle-minus"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0" /><path d="M9 12l6 0" /></svg>
                    </button>
                    <input type="number" class="form-control pop-up-addon-cart-qty" value="1" min="1">
                    <button class="btn pop-up-addon-cart-qty-plus text-lime" type="button">
                        <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon me-0 icon-tabler icons-tabler-outline icon-tabler-circle-plus"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0" /><path d="M9 12h6" /><path d="M12 9v6" /></svg>
                    </button>
                </div>
            </div>

        </div>
    @endforeach

</div>    
@endif


<div class="row mt-3">
    <div class="col-12">
        <div class="">
            <label class="form-label">Special Instructions</label>
            <div>
                <textarea name="instructions" id="instructions" class="form-control" cols="10" rows="2" placeholder="Special Instructions"></textarea>
                <div class="invalid-feedback instructions_error"></div>
            </div>
        </div>
    </div>
</div>


{{-- <div class="modal modal-blur fade position-relative rounded bg-surface-backdrop py-6 w-auto h-auto" id="allergen-info-modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <div class="modal-title">Are you sure?</div>
                <div>If you proceed, you will lose all your personal data.</div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-link link-secondary me-auto" data-bs-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-danger" data-bs-dismiss="modal">Yes, delete all my data</button>
            </div>
        </div>
    </div>
</div> --}}


