@extends('canteen.layouts.app')

@section('page-title')
POS
@endsection

@section('page.content')

    <!-- Page body -->
    <div class="page-body">
        <div class="container-xl">
            <div class="row row-cards">
                <div class="col-md-8">

                    <div class="card mb-2">
                        <div class="card-body p-0 d-flex">

                            <div class="nav-scroller">
                                <button type="button" class="nav-scroller-btn nav-scroller-btn--left" aria-label="Scroll left">
                                  <svg title="Left arrow" class="nav-scroller-icon" width="21" height="32" viewBox="0 0 21 32"><path d="M0 16l4.736-4.768L16 0l4.736 4.736L9.504 16l11.232 11.264L16 32 4.736 20.736z"/></svg>
                                </button>
                              
                                <nav class="nav-scroller-nav">
                                  <div class="nav-scroller-content">
                                    @foreach ($categories as $category)
                                        <a href="#" data-catId="{{ $category->id }}" class="nav-scroller-item item-category">{{ $category->name }}</a>    
                                    @endforeach
                                  </div>
                                </nav>
                              
                                <button type="button" class="nav-scroller-btn nav-scroller-btn--right" aria-label="Scroll right">
                                  <svg title="Right arrow" class="nav-scroller-icon" width="21" height="32" viewBox="0 0 21 32"><path d="M0 27.264L11.264 16 0 4.736 4.736 0 16 11.232 20.736 16l-16 16z"/></svg>
                                </button>
                            </div>

                            <div class="pos-search-warp">
                                <div class="input-icon">
                                    <input id="search_query" type="text" class="form-control" placeholder="Search…">
                                    <span class="input-icon-addon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-1">
                                            <path d="M10 10m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0"></path>
                                            <path d="M21 21l-6 -6"></path>
                                        </svg>
                                    </span>
                                </div>
                            </div>

                        </div>
                    </div>

                    <div class="row row-cards">
                        
                        @foreach ($items as $item)
                            <div class="col-md-3 col-sm-3 col-xs-3 pos-item-warp @foreach ($item->category_ids as $itemCatId)catId-{{ $itemCatId }} @endforeach" style="display: none;">
                                <div 
                                    class="card pos-item"
                                    data-itemId="{{ $item->id }}"
                                    data-itemName="{{ isset($item->main_item->name) ? $item->main_item->name .' ('.$item->name.')' : $item->name }}"
                                    data-itemQuantity="{{ $item->stock_quantity }}"
                                    data-itemPrice="{{ $item->price }}"
                                    data-itemTaxIds="@json($item->tax_ids)"
                                    data-addonsCount="{{ $item->addon_count }}"
                                >
                                    <div class="img-responsive img-responsive-21x21 card-img-top" style="background-image: url({{ asset($item->image) }})"></div>
                                    <div class="card-body text-center">
                                        <p class="text-secondary mb-2 item-name">
                                            @if (isset($item->main_item->name))
                                                {{ $item->main_item->name }} ({{ $item->name }})
                                            @else
                                                {{ $item->name }}
                                            @endif
                                        </p>

                                        @if (!empty($item->variants) && count($item->variants) > 0)
                                            <span class="badge badge-outline text-lime">Multiple Sizes</span>
                                        @else
                                            <h4 class="mb-1 item-price">{{ $item->currency }} {{ number_format($item->price, 2, '.', '') }}</h4>
                                        @endif

                                        {{-- <span class="badge badge-outline text-lime">excl. tax</span> --}}
                                    </div>
                                </div>
                            </div>                            
                        @endforeach

                    </div>

                </div>
                <div class="col-md-4 cart-grid">
                    
                    <form action="{{ url('/app/pos/create-order') }}" method="post" class="card" enctype="multipart/form-data" id="form">
                        @method('POST') @csrf
                        <div class="card h-100">
                            <div class="cart-customer-section d-flex justify-content-between p-2">
    
                                <div class="cart-customer-dropdown">
                                    <div>
                                        <select name="customer_id" class="form-control" id="customer_id">
                                            <option value="">Guest Customer</option>
                                            @foreach ($customers as $customer)
                                            <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                                            @endforeach
                                        </select>
                                        <div class="invalid-feedback unit_id_error"></div>
                                    </div>
                                </div>
    
                                <div class="">
                                    <button type="button" id="newCustomer" class="btn btn-6 btn-lime w-100 btn-icon" data-bs-toggle="tooltip" title="New Customer">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                            <path d="M12 5l0 14"></path>
                                            <path d="M5 12l14 0"></path>
                                        </svg>
                                    </button>
                                </div>
    
    
                            </div>
                            <div class="card-body p-2" id="cart_items_warp">
                                <div class="accordion accordion-inverted" id="accordion-inverted">
                                    {{-- <div class="accordion-item crt_item" id="cartItemId_10">
                                        <button class="accordion-header pos-accordion-header collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-10-inverted" aria-expanded="false">
                                            <div class="accordion-header-text pos-accordion-header-text">
                                                <table style="width: 100%">
                                                    <tr>
                                                        <th class="pe-1">Apple <input type="hidden" name="cartItem[{{ $item->id }}][id]" value="10">
                                                        <input type="hidden" class="item_price" value="50.00"></th>
                                                        <th style="width: 110px; text-align:right;">
                                                            <span>AED</span> <span class="item_subtotal">50.00</span>
                                                        </th>
                                                        <th style="width: 30px; text-align:right;">
                                                            <span class="removeCartItem"><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="currentColor" class="me-0 icon icon-tabler icons-tabler-filled icon-tabler-xbox-x text-danger"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 2c5.523 0 10 4.477 10 10s-4.477 10 -10 10s-10 -4.477 -10 -10s4.477 -10 10 -10m3.6 5.2a1 1 0 0 0 -1.4 .2l-2.2 2.933l-2.2 -2.933a1 1 0 1 0 -1.6 1.2l2.55 3.4l-2.55 3.4a1 1 0 1 0 1.6 1.2l2.2 -2.933l2.2 2.933a1 1 0 0 0 1.6 -1.2l-2.55 -3.4l2.55 -3.4a1 1 0 0 0 -.2 -1.4" /></svg></span>
                                                        </th>
                                                    </tr>
                                                </table>
                                            </div>
                                            <div class="accordion-header-toggle">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="icon icon-1"><path d="M6 9l6 6l6 -6"></path></svg>
                                            </div>
                                        </button>
                                        <div id="collapse-10-inverted" class="accordion-collapse collapse" data-bs-parent="#accordion-inverted" style="">
                                            <div class="accordion-body ms-4">
                                                <div id="cart-item-addons-32"></div>
                                                <table style="width: 100%">
                                                    <tr>
                                                        <td class="pe-2">
                                                            <label class="form-label required mb-1">Quantity</label>
                                                            <input type="number" class="form-control item_qty" id="cartItemQty_10" name="cartItem[10][quantity]" value="1" min="1">
                                                        </td>
                                                        <td class="ps-2">
                                                            <label class="form-label mb-1">Discount ({{ $canteen->currency }})</label>
                                                            <input type="number" value="0" class="form-control item_discount" id="cartItemDiscount_10" name="cartItem[10][discount]" placeholder="Discount Amount">
                                                        </td>
                                                        <td>&ensp;&ensp;&ensp;&ensp;</td>
                                                    </tr>

                                                    <tr>
                                                        <td rowspan="2">
                                                            <button data-itemIdforAddon="32" class="btn btn-6 btn-lime w-100 mt-2 showAddons" type="button">
                                                                <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12.5 21h-7.5a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v7.5" /><path d="M3 10h18" /><path d="M10 3v18" /><path d="M16 19h6" /><path d="M19 16v6" /></svg>
                                                                Addons
                                                            </button>
                                                        </td>
                                                    </tr>

                                                </table>
                                            </div>
                                        </div>
                                    </div> --}}
                                </div>
                            </div>
    
                            <div class="cart-amount-summary-warp card-footer">
    
                                <table class="table table-borderless cart-amount-table mb-0">
                                    <tr>
                                        <td>Subtotal</td>
                                        <th class="text-end">
                                            <span>{{ auth()->user()->currency }}</span>
                                            <span id="subtotal">0.00</span>
                                        </th>
                                    </tr>
                                    <tr>
                                        <td>Discount</td>
                                        <th class="text-end">
                                            <span>{{ auth()->user()->currency }}</span>
                                            <span id="discount">0.00</span>
                                        </th>
                                    </tr>
                                    <tr>
                                        <td>Net Amount</td>
                                        <th class="text-end">
                                            <span>{{ auth()->user()->currency }}</span>
                                            <span id="net_amount">0.00</span>
                                        </th>
                                    </tr>
                                    <tr>
                                        <td>Total Tax</td>
                                        <th class="text-end">
                                            <span>{{ auth()->user()->currency }}</span>
                                            <span id="total_tax">0.00</span>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th>Payable Amount</th>
                                        <th class="text-end">
                                            <span>{{ auth()->user()->currency }}</span>
                                            <span id="payable_amount" class="text-orange">0.00</span>
                                        </th>
                                    </tr>
    
                                </table>
    
                                <div class="cart-buttons d-flex justify-content-between mt-2">
    
                                    <a href="{{ url()->current() }}" class="btn btn-6 btn-orange w-100 me-1">
                                        <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M19.933 13.041a8 8 0 1 1 -9.925 -8.788c3.899 -1 7.935 1.007 9.425 4.747" /><path d="M20 4v5h-5" /></svg>
                                        Clear
                                    </a>
    
                                    <button type="submit" class="btn btn-6 btn-lime w-100 ms-1">
                                        <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M3 12h12" /><path d="M11 8l4 4l-4 4" /><path d="M12 21a9 9 0 0 0 0 -18" /></svg>
                                        Proceed
                                    </button>
    
                                </div>
    
                            </div>
    
                        </div>
                    </form>

                </div>
            </div>

        </div>
    </div>

@endsection

@section("page-modal")

    <div class="modal modal-blur fade" id="newCustomerModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-1 modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                <h5 class="modal-title">Create Customer</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="{{ url('/app/ajax/pos/add-customer') }}" method="post" id="addCustomerform">
                    @method('POST') @csrf
                    <div class="modal-body">
                        <div class="mb-3">
                            <label class="form-label required">Name</label>
                            <div>
                                <input type="text" name="name" class="form-control" aria-describedby="name" placeholder="Customer Name">
                                <div class="invalid-feedback name_error"></div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label required">Mobile Number</label>
                            <div>
                                <input type="hidden" name="mobile_code" id="mobile_code">
                                <input type="text" id="mobile_number" name="mobile_number" class="form-control" aria-describedby="mobile_number" placeholder="Mobile Number">
                                <div class="invalid-feedback mobile_number_error"></div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Email</label>
                            <div>
                                <input type="text" name="email" class="form-control" aria-describedby="email" placeholder="Customer Email Address">
                                {{-- <small class="form-hint">Login password will be sent to this email address.</small> --}}
                                <div class="invalid-feedback email_error"></div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Address</label>
                            <div>
                                <input type="text" name="address" class="form-control" aria-describedby="address" placeholder="Customer Address">
                                <div class="invalid-feedback address_error"></div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn me-auto" data-bs-dismiss="modal">
                            <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M3 5a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-14z" /><path d="M9 9l6 6m0 -6l-6 6" /></svg>
                            Close
                        </button>
                        <button type="submit" class="btn btn-primary">
                            <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M6 4h10l4 4v10a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2" /><path d="M12 14m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0" /><path d="M14 4l0 4l-6 0l0 -4" /></svg>
                            Save
                        </button>


                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal modal-blur fade" id="submitOrderModal" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
            <div class="modal-content" id="order-place-modal-content">

                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                <div class="modal-status bg-lime"></div>
                <div class="modal-body text-center py-4">
                    <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon mb-2 text-lime icon-lg"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10.363 3.591l-8.106 13.534a1.914 1.914 0 0 0 1.636 2.871h16.214a1.914 1.914 0 0 0 1.636 -2.87l-8.106 -13.536a1.914 1.914 0 0 0 -3.274 0z" /><path d="M12 9h.01" /><path d="M11 12h1v4h1" /></svg>
                    <h3 class="mb-2 text-lime">Total Payable <br> <span class="text-orange">{{ $canteen->currency }} <span id="submitOrderPaybleAmount">0.00</span></span></h3>
                    <hr class="m-2">
                    <div class="m-2">
                        <h3 class="mb-2 text-lime">Payment Method</h3>
                        <div>
                            @foreach ($payment_methods as $payment_method)
                            <label class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="payment_method_id" value="{{ $payment_method->id }}">
                                <span class="form-check-label fw-bold">{{ $payment_method->name }}</span>
                            </label>
                            @endforeach
                        </div>
                    </div>

                    <div>
                        <h3 class="mb-2 text-lime">Order Instruction</h3>
                        <textarea name="restaurant_instruction" class="form-control"></textarea>
                    </div>

                    <div class="m-2" style="display: {{ auth()->user()->can('orders.update-status') ? '' : 'none' }};">
                        <h3 class="mb-2 text-lime">Order Status</h3>
                        <div>
                            @foreach ($order_statuses as $order_status)
                            <label class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="order_status_id" {{ ($order_status->id == 1) ? "checked" : "" }} value="{{ $order_status->id }}">
                                <span class="form-check-label fw-bold">{{ $order_status->name }}</span>
                            </label>
                            @endforeach
                        </div>
                    </div>

                    <div class="m-2" style="display: {{ auth()->user()->can('others.accept-payment') ? '' : 'none' }};">
                        <h3 class="mb-2 text-lime">Payment Status</h3>
                        <div>
                            @foreach ($payment_statuses as $payment_status)
                            <label class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="payment_status_id" {{ (!auth()->user()->can('others.accept-payment') && $payment_status->id == 1) ? "checked" : "" }} value="{{ $payment_status->id }}">
                                <span class="form-check-label fw-bold">{{ $payment_status->name }}</span>
                            </label>
                            @endforeach
                        </div>
                    </div>

                    <div class="m-2">
                        <h3 class="mb-2 text-lime">Need Cutlery</h3>
                        <div>
                            <label class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="need_cutlery" value="0" checked>
                                <span class="form-check-label fw-bold">No</span>
                            </label>
                            <label class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="need_cutlery" value="1">
                                <span class="form-check-label fw-bold">Yes</span>
                            </label>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <div class="w-100">
                        <div class="row">
                            <div class="col">
                                <a href="#" class="btn btn-3 w-100" data-bs-dismiss="modal">
                                More Item / Close
                                </a>
                            </div>
                            <div class="col">
                                <button type="button" id="placeOrder" class="btn btn-lime btn-4 w-100">
                                Place Order
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                
            </div>
        </div>
    </div>

    <div class="modal modal-blur fade" id="addonModal" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Addons</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="modal-status bg-lime"></div>
                <div class="modal-body text-center p-2 addonModalBody">
                    
                    <table class="table table-selectable table-vcenter text-start">
                        <thead>
                            <tr>
                                <th style="width: 70px;">Select</th>
                                <th>Name</th>
                                <th>Price</th>
                            </tr>
                        </thead>
                        <tbody id="itemAdons_tbody">

                        </tbody>
                    </table>

                </div>
                <div class="modal-footer">
                    <div class="w-100">
                        <div class="row">
                            <div class="col">
                                <a href="#" class="btn btn-3 w-100" data-bs-dismiss="modal">
                                Close
                                </a>
                            </div>
                            <div class="col">
                                <button type="button" class="btn btn-lime btn-4 w-100" id="addonsSubmit">
                                Add
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal modal-blur fade" id="item-modal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    <div class="pop-up-item-warp"></div>
                </div>
                <div class="modal-footer p-0">
                    <button type="button" class="btn btn-lime w-100 pop-up-addtocart-btn">Add to Cart - {{ $canteen->currency }} <span id="pop-up-addtocart-btn-price">0.00</span></button>
                </div>
            </div>
        </div>
    </div>

@endsection

@section("page.css")
    <link rel="stylesheet" href="{{ asset('assets/canteen/css/pos.css') }}">
@endsection

@section("page.js")
    <script>
        const taxesCollection = @json($taxes);
        const currency = "{{ auth()->user()->currency }}";
    </script>
    <script src="{{ asset('assets/canteen/js/pos.js') }}"></script>
    <script>
        $(window).on('load', function () {
            showCategoryItems("{{ isset($categories[0]->id) ? $categories[0]->id : '' }}");
            $(".item-category").first().addClass("active");
        });
    </script>
@endsection