@extends('canteen.layouts.app')

@section('page-title')
Edit Tax
@endsection

@section('page.content')

    <!-- Page header -->
    <div class="page-header">
        <div class="container-xl">
            <div class="row align-items-center mw-100">
                <div class="col">
                    <div class="col">
                        <h2 class="page-title">
                            Edit Tax
                        </h2>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Page body -->
    <div class="page-body">
        <div class="container-xl">

            <div class="row row-cards">
                <div class="col-12">
                    <form action="{{ url('/app/taxes', [$tax->id]) }}" method="post" class="card" id="form">
                        @method('PUT') @csrf
                        <div class="card-body">
                            <div class="row g-5 justify-content-center">
                                <div class="col-lg-6">

                                    <div class="mb-3">
                                        <label class="form-label required">Name</label>
                                        <div>
                                            <input type="text" name="name" class="form-control" aria-describedby="name" placeholder="Tax Name" value="{{ $tax->name }}">
                                            <div class="invalid-feedback name_error"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label required">Type</label>
                                        <div>
                                            <select name="type" class="form-control" id="tax_type">
                                                <option value="">Select Tax Type</option>
                                                <option value="percentage" {{ $tax->type == "percentage" ? "selected" : "" }}>Percentage</option>
                                                <option value="fixed" {{ $tax->type == "fixed" ? "selected" : "" }}>Fixed</option>
                                            </select>
                                            <div class="invalid-feedback type_error"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label required">Value</label>
                                        <div>
                                            <div class="input-group">
                                                <span id="currency_for_fixed" style="display: {{ $tax->type == "fixed" ? "" : "none" }};" class="input-group-text">{{ auth()->user()->currency }}</span>
                                                <input type="number" name="value" class="form-control" aria-describedby="value" placeholder="Tax Value" value="{{ $tax->value }}">
                                            </div>
                                            <div class="invalid-feedback value_error"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Position</label>
                                        <div>
                                            <div>
                                                <input type="number" name="position" class="form-control" aria-describedby="position" placeholder="Position" value="{{ $tax->position }}">
                                                <small class="form-hint">Enter a number to determine the order of this item. Lower numbers appear first.</small>
                                            </div>
                                            <div class="invalid-feedback position_error"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Status</label>
                                        <div>
                                            <label class="form-check form-switch form-switch-lg">
                                                <input name="is_active" class="form-check-input" type="checkbox" {{ ($tax->is_active == 1) ? "checked" : "" }}>
                                                <span class="form-check-label form-check-label-on">Active</span>
                                                <span class="form-check-label form-check-label-off">InActive</span>
                                            </label>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                        <div class="card-footer text-end">
                            <div class="d-flex">
                                <a href="{{ url('/app/taxes') }}" class="btn btn-link">
                                    <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M9 14l-4 -4l4 -4" /><path d="M5 10h11a4 4 0 1 1 0 8h-1" /></svg>
                                    Cancel
                                </a>
                                <button type="submit" class="btn btn-primary ms-auto">
                                    <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M6 4h10l4 4v10a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2" /><path d="M12 14m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0" /><path d="M14 4l0 4l-6 0l0 -4" /></svg>
                                    Save
                                </button>
                            </div>
                        </div>
                    </form>


                </div>
            </div>

        </div>
    </div>


@endsection

@section("page.js")
<script>
    new TomSelect("#tax_type",{});

    $("#tax_type").change(function(){
        $("#currency_for_fixed").hide();
        if($(this).val() == 'fixed'){
            $("#currency_for_fixed").show();
        }
    });

    $("#form").submit(function(e) {
        e.preventDefault();
        var form = $(this);
        var url = form.attr('action');
        $.ajax({
            type: "POST",
            url: url,
            processData: false,
            contentType: false,
            data: new FormData($('#form')[0]),
            beforeSend: function(){
                $(document).find('div.invalid-feedback').text('');
            },
            success: function(data){
                if(data.success){
                    window.location.href = data.redirect_url;
                }else{
                    Notiflix.Notify.failure(data.message);
                }
            },
            error: function(response) {
                $.each(response.responseJSON.errors, function(prefix, val){
                    $('div.'+prefix+'_error').text(val[0]);
                })
                $('.error-text').css({'display':'inline'});
                Notiflix.Notify.failure(response.responseJSON.message);
            }
        });
    });

</script>
@endsection