

<?php $__env->startSection('page-title'); ?>
    Permissions
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page.content'); ?>

    <!-- Page header -->
    <div class="page-header">
        <div class="container-xl">
            <div class="row align-items-center mw-100">
                <div class="col">
                    <h2 class="page-title">
                        Permissions
                    </h2>
                </div>
            </div>
        </div>
    </div>

    <!-- Page body -->
    <div class="page-body">
        <div class="container-xl">

            <div class="row row-cards">
                <div class="col-12">
                    <div class="card">
                
                        <div class="table-responsive min-h-500">
                            <table class="table card-table table-vcenter text-nowrap">
                                <thead>
                                    <tr>
                                        <td colspan="10">
                                            <div class="row justify-content-center">
                                                <div class="col-md-6">
                                                    <div class="mb-3">
                                                        <label class="form-label required">Employee</label>
                                                        <div>
                                                            <select name="type" class="form-control" id="employee">
                                                                <option value="">Select Employee</option>
                                                                <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($employee->id); ?>"><?php echo e($employee->name); ?> - <span class="badge"><?php echo e($employee->designation); ?></span></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                            <div class="invalid-feedback employee_error"></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                </thead>
                                <thead>
                                    <tr>
                                        <th>Module</th>
                                        <th colspan="10">Permissions</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    <tr>
                                        <th>
                                            <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-shopping-cart"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M6 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0" /><path d="M17 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0" /><path d="M17 17h-11v-14h-2" /><path d="M6 5l14 1l-1 7h-13" /></svg>
                                            Orders
                                        </th>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="1">
                                                <span class="form-check-label">
                                                    Read
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to view orders
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="2">
                                                <span class="form-check-label">
                                                    Create
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to create new orders - POS access
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="3">
                                                <span class="form-check-label">
                                                    Update
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to edit existing orders
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="4">
                                                <span class="form-check-label">
                                                    Update Status
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to update order status
                                                </span>
                                            </label>
                                        </td>

                                    </tr>

                                    <tr>
                                        <th>
											<svg class="me-1" xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-users"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M9 7m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0" /><path d="M3 21v-2a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v2" /><path d="M16 3.13a4 4 0 0 1 0 7.75" /><path d="M21 21v-2a4 4 0 0 0 -3 -3.85" /></svg>
                                            Customers
                                        </th>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="5">
                                                <span class="form-check-label">
                                                    Read
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to view customers
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="6">
                                                <span class="form-check-label">
                                                    Create
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to create new customer
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="7">
                                                <span class="form-check-label">
                                                    Update
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to edit existing customer
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="8">
                                                <span class="form-check-label">
                                                    Delete
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to delete customer
                                                </span>
                                            </label>
                                        </td>

                                    </tr>

                                    <tr>
                                        <th>
                                            <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-border-all"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z" /><path d="M4 12l16 0" /><path d="M12 4l0 16" /></svg>
                                            Tables
                                        </th>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="9">
                                                <span class="form-check-label">
                                                    Read
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to view tables
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="10">
                                                <span class="form-check-label">
                                                    Create
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to create new table
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="11">
                                                <span class="form-check-label">
                                                    Update
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to edit existing table
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="12">
                                                <span class="form-check-label">
                                                    Delete
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to delete table
                                                </span>
                                            </label>
                                        </td>

                                    </tr>

                                    <tr>
                                        <th>
                                            <svg class="me-1" xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-category"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M4 4h6v6h-6z" /><path d="M14 4h6v6h-6z" /><path d="M4 14h6v6h-6z" /><path d="M17 17m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0" /></svg>
                                            Menu > Categories
                                        </th>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="13">
                                                <span class="form-check-label">
                                                    Read
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to view categories
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="14">
                                                <span class="form-check-label">
                                                    Create
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to create new category
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="15">
                                                <span class="form-check-label">
                                                    Update
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to edit existing category
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="16">
                                                <span class="form-check-label">
                                                    Delete
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to delete category
                                                </span>
                                            </label>
                                        </td>

                                    </tr>

                                    <tr>
                                        <th>
                                            <svg class="me-1" xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-template"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M4 4m0 1a1 1 0 0 1 1 -1h14a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-14a1 1 0 0 1 -1 -1z" /><path d="M4 12m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z" /><path d="M14 12l6 0" /><path d="M14 16l6 0" /><path d="M14 20l6 0" /></svg>
											Menu > Items
                                        </th>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="17">
                                                <span class="form-check-label">
                                                    Read
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to view items
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="18">
                                                <span class="form-check-label">
                                                    Create
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to create new item
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="19">
                                                <span class="form-check-label">
                                                    Update
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to edit existing item
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="20">
                                                <span class="form-check-label">
                                                    Delete
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to delete item
                                                </span>
                                            </label>
                                        </td>

                                    </tr>

                                    <tr>
                                        <th>
                                            <svg class="me-1" xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-report"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M8 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h5.697" /><path d="M18 14v4h4" /><path d="M18 11v-4a2 2 0 0 0 -2 -2h-2" /><path d="M8 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z" /><path d="M18 18m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0" /><path d="M8 11h4" /><path d="M8 15h3" /></svg>
											Reports
                                        </th>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="21">
                                                <span class="form-check-label">
                                                    Cash Transactions - Read
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to view & export <br> Cash Transactions
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="22">
                                                <span class="form-check-label">
                                                    QR Code Transactions - Read
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to view & export <br> QR Code Transactions
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="23">
                                                <span class="form-check-label">
                                                    Online Transactions - Read
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to view & export <br> Online Transactions
                                                </span>
                                            </label>
                                        </td>
                                        
                                        <td></td>

                                    </tr>

                                    <tr>
                                        <th>
                                            <svg class="me-1" xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-user-shield"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M6 21v-2a4 4 0 0 1 4 -4h2" /><path d="M22 16c0 4 -2.5 6 -3.5 6s-3.5 -2 -3.5 -6c1 0 2.5 -.5 3.5 -1.5c1 1 2.5 1.5 3.5 1.5z" /><path d="M8 7a4 4 0 1 0 8 0a4 4 0 0 0 -8 0" /></svg>
                                            Employees
                                        </th>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="24">
                                                <span class="form-check-label">
                                                    Read
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to view employees
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="25">
                                                <span class="form-check-label">
                                                    Create
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to create new employee
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="26">
                                                <span class="form-check-label">
                                                    Update
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to edit existing employee
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="27">
                                                <span class="form-check-label">
                                                    Delete
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to delete employee
                                                </span>
                                            </label>
                                        </td>

                                    </tr>

                                    <tr>
                                        <th>
                                            <svg class="me-1" xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-tax"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M8.487 21h7.026a4 4 0 0 0 3.808 -5.224l-1.706 -5.306a5 5 0 0 0 -4.76 -3.47h-1.71a5 5 0 0 0 -4.76 3.47l-1.706 5.306a4 4 0 0 0 3.808 5.224" /><path d="M15 3q -1 4 -3 4t -3 -4z" /><path d="M14 11h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5" /><path d="M12 10v1" /><path d="M12 17v1" /></svg>
                                            Settings > Taxes
                                        </th>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="28">
                                                <span class="form-check-label">
                                                    Read
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to view taxes
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="29">
                                                <span class="form-check-label">
                                                    Create
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to create new tax
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="30">
                                                <span class="form-check-label">
                                                    Update
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to edit existing tax
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="31">
                                                <span class="form-check-label">
                                                    Delete
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to delete tax
                                                </span>
                                            </label>
                                        </td>

                                    </tr>

                                    <tr>
                                        <th>
                                            <svg class="me-1" xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-scale"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M7 20l10 0" /><path d="M6 6l6 -1l6 1" /><path d="M12 3l0 17" /><path d="M9 12l-3 -6l-3 6a3 3 0 0 0 6 0" /><path d="M21 12l-3 -6l-3 6a3 3 0 0 0 6 0" /></svg>
                                            Settings > Units
                                        </th>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="32">
                                                <span class="form-check-label">
                                                    Read
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to view Units
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="33">
                                                <span class="form-check-label">
                                                    Create
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to create new Units
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="34">
                                                <span class="form-check-label">
                                                    Update
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to edit existing Units
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="35">
                                                <span class="form-check-label">
                                                    Delete
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to delete Units
                                                </span>
                                            </label>
                                        </td>

                                    </tr>
                                    
                                    <tr>
                                        <th>
                                            <svg class="me-1" xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-badge"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M17 17v-13l-5 3l-5 -3v13l5 3z" /></svg>
                                            Settings > Item Badges
                                        </th>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="39">
                                                <span class="form-check-label">
                                                    Read
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to view Item Badges
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="40">
                                                <span class="form-check-label">
                                                    Create
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to create new Item Badge
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="41">
                                                <span class="form-check-label">
                                                    Update
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to edit existing Item Badge
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="42">
                                                <span class="form-check-label">
                                                    Delete
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to delete Item Badge
                                                </span>
                                            </label>
                                        </td>

                                    </tr>

                                    <tr>
                                        <th>
                                            <svg class="me-1" xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-scale"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M7 20l10 0" /><path d="M6 6l6 -1l6 1" /><path d="M12 3l0 17" /><path d="M9 12l-3 -6l-3 6a3 3 0 0 0 6 0" /><path d="M21 12l-3 -6l-3 6a3 3 0 0 0 6 0" /></svg>
                                            Others
                                        </th>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="37">
                                                <span class="form-check-label">
                                                    Accept Payment
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to receive and confirm <br> order payments
                                                </span>
                                            </label>
                                        </td>

                                        <td>
                                            <label class="form-check">
                                                <input class="form-check-input permission" type="checkbox" value="38">
                                                <span class="form-check-label">
                                                    Business Setting
                                                </span>
                                                <span class="form-check-description">
                                                    Allows to modify Plans/Business <br> setting, view Billing & Invoices
                                                </span>
                                            </label>
                                        </td>

                                        

                                    </tr>

                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
            </div>
            
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection("page.js"); ?>
    <script>

        $(".permission").change(function() {

            if(!$("#employee").val()){
                Notiflix.Notify.failure('Please select an Employee');
                $("#employee").focus();

                if(this.checked){
                    $(this).prop("checked", false);
                }else{
                    $(this).prop("checked", true);
                }
                return;
            }

            if(this.checked) {
                syncAdminPermission($("#employee").val(), $(this).val(), 'give');
            } else {
                syncAdminPermission($("#employee").val(), $(this).val(), 'revoke');
            }
        });

        $("#employee").change(function() {
            $.ajax({
                url: "/app/ajax/users/permissions/"+$(this).val(),
                type: 'GET',
                dataType: 'json',
                success: function(res) {
                    let permissions = res.data;
                    $('.form-check-input.permission').each(function () {
                        let val = parseInt($(this).val(), 10);
                        if (permissions.includes(val)) {
                            $(this).prop('checked', true);
                        } else {
                            $(this).prop('checked', false);
                        }
                    });
                }
            });
        });

        function syncAdminPermission(userId, permission_id, action){
            $.ajax({
                url: "/app/permissions/sync",
                type: 'POST',
                dataType: 'json',
                data: {
                    "_token": "<?php echo e(csrf_token()); ?>",
                    userId: userId,
                    permission_id: permission_id,
                    action: action,
                },
                success: function(res) {
                    Notiflix.Notify.success(res.message);
                }
            });
        }

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('canteen.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\php-projects\therpos\resources\views/canteen/pages/permissions/index.blade.php ENDPATH**/ ?>