<!doctype html>
<html lang="en">
    <head>
        <meta charset="utf-8"/>
        <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover"/>
        <meta http-equiv="X-UA-Compatible" content="ie=edge"/>
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <title> <?php echo $__env->yieldContent('page-title'); ?> | <?php echo e(config('app.name')); ?></title>

        <link href="<?php echo e(asset('assets/canteen/css/tabler.min.css')); ?>" rel="stylesheet"/>
        <link rel="stylesheet" href="<?php echo e(asset('assets/canteen/css/jquery.passwordRequirements.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets/canteen/css/auth_custom.css')); ?>">
        <!-- CSS files -->
        <?php echo $__env->yieldContent('page.css'); ?>
        
    </head>
    <body class=" d-flex flex-column">

        <div class="page">
            <?php echo $__env->yieldContent('page.content'); ?>
        </div>

		<!-- Libs JS -->
		<script src="<?php echo e(asset('assets/canteen/js/jquery-3.7.1.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/canteen/js/jquery.passwordRequirements.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/canteen/js/notiflix-aio.min.js')); ?>"></script>
        <script src="<?php echo e(asset('assets/canteen/js/auth_custom.js')); ?>"></script>
        <!-- Tabler Core -->
        <script src="<?php echo e(asset('assets/canteen/js/tabler.min.js')); ?>" defer></script>

        <?php echo $__env->yieldContent('page.js'); ?>
		<script>

			Notiflix.Notify.init({
				clickToClose: true
			});
	
			<?php if(Session::has('message')): ?>
				Notiflix.Notify.success("<?php echo e(session('message')); ?>");
			<?php endif; ?>
	
			<?php if(Session::has('error')): ?>
				Notiflix.Notify.failure("<?php echo e(session('error')); ?>");
			<?php endif; ?>
	
			<?php if(Session::has('info')): ?>
				Notiflix.Notify.info("<?php echo e(session('info')); ?>");
			<?php endif; ?>
	
			<?php if(Session::has('warning')): ?>
				Notiflix.Notify.warning("<?php echo e(session('warning')); ?>");
			<?php endif; ?>
	
		</script>
    </body>
</html>
<?php /**PATH D:\php-projects\therpos\resources\views/canteen/layouts/auth.blade.php ENDPATH**/ ?>