

<?php $__env->startSection('page-title'); ?>
Business Settings
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page.content'); ?>

    <!-- Page header -->
    <div class="page-header">
        <div class="container-xl">
            <div class="row align-items-center mw-100">
                <div class="col">
                    <div class="col">
                        <h2 class="page-title">
                            Business Settings
                        </h2>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Page body -->
    <div class="page-body">
        <div class="container-xl">

			<div class="card">
				<div class="row g-0">
					<div class="col-12 col-md-3 border-end">
                        <?php echo $__env->make('canteen.pages.profile.sidenav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
					</div>
					<div class="col-12 col-md-9 d-flex flex-column">
                        <form action="<?php echo e(url('/app/business-settings')); ?>" method="post" class="card" enctype="multipart/form-data" id="form">
                            <?php echo method_field('POST'); ?> <?php echo csrf_field(); ?>

                            <div class="card-body">
                                <div class="card-status-top bg-light"></div>
                                <h3 class="card-title">Business Settings</h3>
                                <div class="row align-items-center">
                                    <label class="form-label">Logo</label>
                                    <div class="col-auto">
                                        <span class="avatar avatar-xl" id="logo_preview" style="background-image: url(<?php echo e(asset($business->logo)); ?>)"></span>
                                    </div>
                                    <div class="col-auto">
                                        <a href="#" class="btn btn-1" id="change_logo">
                                            Change Logo
                                        </a>
                                    </div>
                                    <input type="file" id="logo_file_input" name="logo" accept="image/*" style="display: none;">
                                </div>
    
                                <br>
    
                                <div class="mb-3">
                                    <label class="form-label required">Business Name</label>
                                    <div>
                                        <input type="text" name="business_name" class="form-control" aria-describedby="business_name" placeholder="Business Name" value="<?php echo e($business->business_name); ?>">
                                        <div class="invalid-feedback business_name_error"></div>
                                    </div>
                                </div>
    
                                <div class="mb-3">
                                    <label class="form-label required">User Name</label>
                                    <div>
                                        <div class="">
                                            <input type="text" name="user_name" class="form-control" aria-describedby="user_name" placeholder="User Name" value="<?php echo e($business->user_name); ?>">
                                            <small class="form-hint text-warning">This will be part of your website’s web address. (e.g. <?php echo e($business->user_name); ?>.<?php echo e(config('app.hostname')); ?>)</small>
                                        </div>
                                        <div class="invalid-feedback user_name_error"></div>
                                    </div>
                                </div>
    
                                <div class="mb-3">
                                    <label class="form-label required">Owner Name</label>
                                    <div>
                                        <input type="text" name="owner_name" class="form-control" aria-describedby="owner_name" placeholder="Owner Name" value="<?php echo e($business->name); ?>">
                                        <div class="invalid-feedback owner_name_error"></div>
                                    </div>
                                </div>
    
                                <div class="mb-3">
                                    <label class="form-label required">Business Email</label>
                                    <div>
                                        <input type="text" name="business_email" class="form-control" aria-describedby="business_email" placeholder="Business Email Address" value="<?php echo e($business->email); ?>">
                                        <div class="invalid-feedback business_email_error"></div>
                                    </div>
                                </div>
    
                                <div class="mb-3">
                                    <label class="form-label required">Business Mobile Number</label>
                                    <div>
                                        <input type="text" id="mobile_number" name="business_mobile_number" class="form-control" aria-describedby="mobile_number" placeholder="Business Contact" value="<?php echo e($business->mobile_number); ?>">
                                        <div class="invalid-feedback business_mobile_number_error"></div>
                                    </div>
                                </div>
    
                                <div class="mb-3">
                                    <label class="form-label required">POS Payment Methods</label>
                                    <div>
                                        <select name="pos_payment_methods_ids[]" class="form-control" id="pos_payment_methods_ids" multiple>
                                            <option value="">Select Payment Methods</option>
                                            <?php $__currentLoopData = $payment_methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment_method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(is_array($business->pos_payment_methods_ids) && in_array($payment_method->id, $business->pos_payment_methods_ids) ? "selected" : ""); ?> value="<?php echo e($payment_method->id); ?>"><?php echo e($payment_method->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <small class="form-hint text-warning">Payment methods available at your POS system</small>
                                        <div class="invalid-feedback pos_payment_methods_ids_error"></div>
                                    </div>
                                </div>
    
                                <div class="mb-3">
                                    <label class="form-label required">Website Payment Methods</label>
                                    <div>
                                        <select name="web_payment_methods_ids[]" class="form-control" id="web_payment_methods_ids" multiple>
                                            <option value="">Select Payment Methods</option>
                                            <?php $__currentLoopData = $payment_methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment_method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(is_array($business->web_payment_methods_ids) && in_array($payment_method->id, $business->web_payment_methods_ids) ? "selected" : ""); ?> value="<?php echo e($payment_method->id); ?>"><?php echo e($payment_method->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <small class="form-hint text-warning">Payment methods customers can use when ordering online</small>
                                        <div class="invalid-feedback web_payment_methods_ids_error"></div>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label required">Business Address</label>
                                    <div>
                                        <input type="text" name="business_address" class="pr-password form-control" aria-describedby="business_address" placeholder="Business Address (e.g. 365/11, West Kafrul, Dhaka 1207)" value="<?php echo e($business->address); ?>">
                                        <div class="invalid-feedback business_address_error"></div>
                                    </div>
                                </div>
                                
                                <?php if(auth()->user()->id == auth()->user()->main_id): ?>
                                <div>
                                    <label class="form-label">Admin Password</label>
                                    <a href="#" class="btn btn-1" data-bs-toggle="modal" data-bs-target="#adminPassword">
                                        Change admin password
                                    </a>
                                </div>                                    
                                <?php endif; ?>
                                
                                <h3 class="card-title mt-4 mb-2">Available</h3>
                                <div>
                                    <label class="form-check form-switch form-switch-lg">
                                        <input class="form-check-input" name="is_available" type="checkbox" <?php echo e(($business->is_available == 1) ? "checked" : ""); ?>>
                                        <span class="form-check-label form-check-label-on text-success">Business is available to take orders.</span>
                                        <span class="form-check-label form-check-label-off text-danger">Business is not available to take orders.</span>
                                    </label>
                                </div>
                            </div>

                            <div class="card-footer text-end">
                                <div class="d-flex">
                                    <a href="<?php echo e(url('/app')); ?>" class="btn btn-link">
                                        <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M9 14l-4 -4l4 -4" /><path d="M5 10h11a4 4 0 1 1 0 8h-1" /></svg>
                                        Cancel
                                    </a>
                                    <button type="submit" class="btn btn-primary ms-auto">
                                        <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M6 4h10l4 4v10a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2" /><path d="M12 14m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0" /><path d="M14 4l0 4l-6 0l0 -4" /></svg>
                                        Save
                                    </button>
                                </div>
                            </div>
                        </form>
					</div>
				</div>
			</div>

        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-modal'); ?>
<div class="modal modal-blur fade" id="adminPassword" data-bs-backdrop="static" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog modal-1 modal-dialog-centered" role="document">
		<div class="modal-content">
            <form action="<?php echo e(url('/app/change-password')); ?>" id="changePasswordForm">
                <?php echo method_field('POST'); ?> <?php echo csrf_field(); ?>

                <div class="modal-header">
                    <h5 class="modal-title">Change Admin Password</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">

                    <div class="mb-2">
                        <label class="form-label">Current Password</label>
                        <div class="input-group input-group-flat">
                            <input type="password" name="current_password" class="form-control" placeholder="Current password" autocomplete="off">
                            <span class="input-group-text">
                                <a href="#" class="link-secondary password_toggle" title="Show password" data-bs-toggle="tooltip">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon d-none password_show" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" /><path d="M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6" /></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-eye-off password_hide" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10.585 10.587a2 2 0 0 0 2.829 2.828" /><path d="M16.681 16.673a8.717 8.717 0 0 1 -4.681 1.327c-3.6 0 -6.6 -2 -9 -6c1.272 -2.12 2.712 -3.678 4.32 -4.674m2.86 -1.146a9.055 9.055 0 0 1 1.82 -.18c3.6 0 6.6 2 9 6c-.666 1.11 -1.379 2.067 -2.138 2.87" /><path d="M3 3l18 18" /></svg>
                                </a>
                            </span>
                        </div>
                        <div class="invalid-feedback current_password_error"></div>
                    </div>

                    <div class="mb-2">
                        <label class="form-label">New Password</label>
                        <div class="input-group input-group-flat">
                            <input type="password" name="new_password" class="form-control pr-password" placeholder="New password" autocomplete="off">
                            <span class="input-group-text">
                                <a href="#" class="link-secondary password_toggle" title="Show password" data-bs-toggle="tooltip">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon d-none password_show" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" /><path d="M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6" /></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-eye-off password_hide" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10.585 10.587a2 2 0 0 0 2.829 2.828" /><path d="M16.681 16.673a8.717 8.717 0 0 1 -4.681 1.327c-3.6 0 -6.6 -2 -9 -6c1.272 -2.12 2.712 -3.678 4.32 -4.674m2.86 -1.146a9.055 9.055 0 0 1 1.82 -.18c3.6 0 6.6 2 9 6c-.666 1.11 -1.379 2.067 -2.138 2.87" /><path d="M3 3l18 18" /></svg>
                                </a>
                            </span>
                        </div>
                        <div class="invalid-feedback new_password_error"></div>
                    </div>

                    <div class="mb-2">
                        <label class="form-label">Confirm New Password</label>
                        <div class="input-group input-group-flat">
                            <input type="password" name="new_password_confirmation" class="form-control" placeholder="Confirm new password" autocomplete="off">
                            <span class="input-group-text">
                                <a href="#" class="link-secondary password_toggle" title="Show password" data-bs-toggle="tooltip">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon d-none password_show" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" /><path d="M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6" /></svg>
                                    <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-eye-off password_hide" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10.585 10.587a2 2 0 0 0 2.829 2.828" /><path d="M16.681 16.673a8.717 8.717 0 0 1 -4.681 1.327c-3.6 0 -6.6 -2 -9 -6c1.272 -2.12 2.712 -3.678 4.32 -4.674m2.86 -1.146a9.055 9.055 0 0 1 1.82 -.18c3.6 0 6.6 2 9 6c-.666 1.11 -1.379 2.067 -2.138 2.87" /><path d="M3 3l18 18" /></svg>
                                </a>
                            </span>
                        </div>
                        <div class="invalid-feedback new_password_confirmation_error"></div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn me-auto" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">
                        <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M6 4h10l4 4v10a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2" /><path d="M12 14m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0" /><path d="M14 4l0 4l-6 0l0 -4" /></svg>
                        Save
                    </button>
                </div>

            </form>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page.css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('assets/canteen/css/jquery.passwordRequirements.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection("page.js"); ?>
<script src="<?php echo e(asset('assets/canteen/js/jquery.passwordRequirements.min.js')); ?>"></script>
<script>
    new TomSelect("#pos_payment_methods_ids",{});
    new TomSelect("#web_payment_methods_ids",{});

    $("#form").submit(function(e) {
        e.preventDefault();
        var form = $(this);
        var url = form.attr('action');
        $.ajax({
            type: "POST",
            url: url,
            processData: false,
            contentType: false,
            data: new FormData($('#form')[0]),
            beforeSend: function(){
                $(document).find('div.invalid-feedback').text('');
            },
            success: function(data){
                if(data.success){
                    window.location.href = data.redirect_url;
                }else{
                    Notiflix.Notify.failure(data.message);
                }
            },
            error: function(response) {
                $.each(response.responseJSON.errors, function(prefix, val){
                    $('div.'+prefix+'_error').text(val[0]);
                })
                $('.error-text').css({'display':'inline'});
                Notiflix.Notify.failure(response.responseJSON.message);
            }
        });
    });

    $("#changePasswordForm").submit(function(e) {
        e.preventDefault();
        var form = $(this);
        var url = form.attr('action');
        $.ajax({
            type: "POST",
            url: url,
            processData: false,
            contentType: false,
            data: new FormData($('#changePasswordForm')[0]),
            beforeSend: function(){
                $(document).find('div.invalid-feedback').text('');
            },
            success: function(data){
                if(data.success){
                    $("#adminPassword").modal('hide');
                    $("#changePasswordForm")[0].reset();
                    Notiflix.Notify.success(data.message);
                }else{
                    Notiflix.Notify.failure(data.message);
                }
            },
            error: function(response) {
                $.each(response.responseJSON.errors, function(prefix, val){
                    $('div.'+prefix+'_error').text(val[0]);
                })
                $('.error-text').css({'display':'inline'});
                Notiflix.Notify.failure(response.responseJSON.message);
            }
        });
    });

    $(document).ready(function () {
        // Step 1: Trigger file input when "Change Logo" is clicked
        $('#change_logo').click(function (e) {
            e.preventDefault();
            $('#logo_file_input').click();
        });

        // Step 2: Handle file selection
        $('#logo_file_input').on('change', function () {

            const file = this.files[0];

            if (file) {

                if (file.size > 524288) {
                    // Reset the file input so user can select again
                    $(this).val('');
                    Notiflix.Notify.failure("Oops! Your logo file is too large. Maximum allowed size is 512KB.");
                    return;
                }

                // Update the preview
                const reader = new FileReader();
                reader.onload = function (e) {
                    $('#logo_preview').css('background-image', 'url(' + e.target.result + ')');
                };
                reader.readAsDataURL(file);

                // If needed: Store the filename or other data in hidden input
                $('#logo_hidden').val(file.name);
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('canteen.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\php-projects\therpos\resources\views/canteen/pages/profile/businessSettings.blade.php ENDPATH**/ ?>