

<?php $__env->startSection('page-title'); ?>
Create Employee
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page.content'); ?>

    <!-- Page header -->
    <div class="page-header">
        <div class="container-xl">
            <div class="row align-items-center mw-100">
                <div class="col">
                    <div class="col">
                        <h2 class="page-title">
                          Create Employee
                        </h2>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Page body -->
    <div class="page-body">
        <div class="container-xl">

            <div class="row row-cards">
                <div class="col-12">
                    <form action="<?php echo e(url('/app/employees')); ?>" method="post" class="card" id="form">
                        <?php echo method_field('POST'); ?> <?php echo csrf_field(); ?>
                        <div class="card-body">
                            <div class="row g-5 justify-content-center">
                                <div class="col-lg-6">

                                    <div class="mb-3">
                                        <label class="form-label required">Designation</label>
                                        <div>
                                            <select name="designation" class="form-control" id="designation">
                                                <option value="">Select Designation</option>
                                                <option value="Manager">Manager</option>
                                                <option value="Supervisor">Supervisor</option>
                                                <option value="Head Chef">Head Chef</option>
                                                <option value="Cook">Cook</option>
                                                <option value="Kitchen Helper">Kitchen Helper</option>
                                                <option value="Head Waiter">Head Waiter</option>
                                                <option value="Waiter">Waiter</option>
                                                <option value="Barista">Barista</option>
                                                <option value="Bartender">Bartender</option>
                                                <option value="Cleaner">Cleaner</option>
                                                <option value="Dish Washer">Dish Washer</option>
                                            </select>
                                            <div class="invalid-feedback type_error"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label required">Name</label>
                                        <div>
                                            <input type="text" name="name" class="form-control" aria-describedby="name" placeholder="Full Name">
                                            <div class="invalid-feedback name_error"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Email</label>
                                        <div>
                                            <input type="text" name="email" class="form-control" aria-describedby="email" placeholder="Email Address">
                                            <small class="form-hint">Login credential will be sent to this email address.</small>
                                            <div class="invalid-feedback email_error"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label required">Mobile Number</label>
                                        <div>
                                            <input type="hidden" name="mobile_code" id="mobile_code">
                                            <input type="text" id="mobile_number" name="mobile_number" class="form-control" aria-describedby="mobile_number" placeholder="Mobile Number">
                                            <div class="invalid-feedback mobile_number_error"></div>
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Address</label>
                                        <div>
                                            <input type="text" name="address" class="form-control" aria-describedby="address" placeholder="Address">
                                            <div class="invalid-feedback address_error"></div>
                                        </div>
                                    </div>

                                </div>

                            </div>
                        </div>
                        <div class="card-footer text-end">
                            <div class="d-flex">
                                <a href="<?php echo e(url('/app/employees')); ?>" class="btn btn-link">
                                    <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M9 14l-4 -4l4 -4" /><path d="M5 10h11a4 4 0 1 1 0 8h-1" /></svg>
                                    Cancel
                                </a>
                                <button type="submit" class="btn btn-primary ms-auto">
                                    <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M6 4h10l4 4v10a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2" /><path d="M12 14m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0" /><path d="M14 4l0 4l-6 0l0 -4" /></svg>
                                    Save
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startSection("page.js"); ?>
<script>
    new TomSelect("#designation",{});

    $("#form").submit(function(e) {
        e.preventDefault();
        var form = $(this);
        var url = form.attr('action');
        $.ajax({
            type: "POST",
            url: url,
            processData: false,
            contentType: false,
            data: new FormData($('#form')[0]),
            beforeSend: function(){
                $(document).find('div.invalid-feedback').text('');
            },
            success: function(data){
                if(data.success){
                    window.location.href = data.redirect_url;
                }else{
                    Notiflix.Notify.failure(data.message);
                }
            },
            error: function(response) {
                $.each(response.responseJSON.errors, function(prefix, val){
                    $('div.'+prefix+'_error').text(val[0]);
                })
                $('.error-text').css({'display':'inline'});
                Notiflix.Notify.failure(response.responseJSON.message);
            }
        });
    });

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('canteen.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\php-projects\therpos\resources\views/canteen/pages/employee/create.blade.php ENDPATH**/ ?>