<!doctype html>
<html lang="en">
	<head>
		<meta charset="utf-8"/>
		<meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover"/>
		<meta http-equiv="X-UA-Compatible" content="ie=edge"/>
		<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

		<title> <?php echo $__env->yieldContent('page-title'); ?> | <?php echo e(config('app.name')); ?></title>
		<!-- CSS files -->
		<link href="<?php echo e(asset('assets/canteen/css/tabler.min.css?v=12345')); ?>" rel="stylesheet"/>
		<link rel="stylesheet" href="<?php echo e(asset('assets/canteen/css/jquery.passwordRequirements.css')); ?>">
		<link rel="stylesheet" href="<?php echo e(asset('assets/canteen/css/tom-select.bootstrap5.min.css')); ?>">
		<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/intl-tel-input@24.5.0/build/css/intlTelInput.css">
		<link rel="stylesheet" href="<?php echo e(asset('assets/canteen/css/app_custom.css')); ?>">
		<!-- CSS files -->
		<?php echo $__env->yieldContent('page.css'); ?>
	</head>
	<body>
		<div class="page">
			<?php echo $__env->make('canteen.partials.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
			<div class="page-wrapper">
				<?php echo $__env->yieldContent('page.content'); ?>
				<?php echo $__env->make('canteen.partials.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
			</div>
		</div>

		<?php echo $__env->yieldContent('page-modal'); ?>

		<!-- Libs JS -->
		<script src="<?php echo e(asset('assets/canteen/js/notiflix-aio.min.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/canteen/js/jquery-3.7.1.min.js')); ?>"></script>
		<!-- Tabler Core -->
		<script src="<?php echo e(asset('assets/canteen/js/tabler.min.js')); ?>" defer></script>
		<script src="<?php echo e(asset('assets/canteen/js/theme.min.js')); ?>" defer></script>

		<!-- Firebase CDN (compat) -->
		<script src="https://www.gstatic.com/firebasejs/12.2.1/firebase-app-compat.js"></script>
		<script src="https://www.gstatic.com/firebasejs/12.2.1/firebase-messaging-compat.js"></script>
		<script src="<?php echo e(asset('assets/firebase/fcm-notification.js')); ?>"></script>

		<script src="<?php echo e(asset('assets/canteen/js/jquery.passwordRequirements.min.js')); ?>"></script>
		<script src="<?php echo e(asset('assets/canteen/js/tom-select.complete.min.js')); ?>"></script>
		<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@24.5.0/build/js/intlTelInput.min.js"></script>

		<!-- Custom JS -->
		<script src="<?php echo e(asset('assets/canteen/js/app_custom.js')); ?>"></script>
		<?php echo $__env->yieldContent('page.js'); ?>
		<script>

			Notiflix.Notify.init({
				clickToClose: true
			});
	
			<?php if(Session::has('message')): ?>
				Notiflix.Notify.success("<?php echo e(session('message')); ?>");
			<?php endif; ?>
	
			<?php if(Session::has('error')): ?>
				Notiflix.Notify.failure("<?php echo e(session('error')); ?>");
			<?php endif; ?>
	
			<?php if(Session::has('info')): ?>
				Notiflix.Notify.info("<?php echo e(session('info')); ?>");
			<?php endif; ?>
	
			<?php if(Session::has('warning')): ?>
				Notiflix.Notify.warning("<?php echo e(session('warning')); ?>");
			<?php endif; ?>
	
		</script>
	</body>
</html>
<?php /**PATH D:\php-projects\therpos\resources\views/canteen/layouts/app.blade.php ENDPATH**/ ?>