<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Backupdr;

class BackupPlan extends \Google\Collection
{
  protected $collection_key = 'supportedResourceTypes';
  protected $backupRulesType = BackupRule::class;
  protected $backupRulesDataType = 'array';
  /**
   * @var string
   */
  public $backupVault;
  /**
   * @var string
   */
  public $backupVaultServiceAccount;
  /**
   * @var string
   */
  public $createTime;
  /**
   * @var string
   */
  public $description;
  /**
   * @var string
   */
  public $etag;
  /**
   * @var string[]
   */
  public $labels;
  /**
   * @var string
   */
  public $logRetentionDays;
  /**
   * @var string
   */
  public $name;
  /**
   * @var string
   */
  public $resourceType;
  /**
   * @var string
   */
  public $revisionId;
  /**
   * @var string
   */
  public $revisionName;
  /**
   * @var string
   */
  public $state;
  /**
   * @var string[]
   */
  public $supportedResourceTypes;
  /**
   * @var string
   */
  public $updateTime;

  /**
   * @param BackupRule[]
   */
  public function setBackupRules($backupRules)
  {
    $this->backupRules = $backupRules;
  }
  /**
   * @return BackupRule[]
   */
  public function getBackupRules()
  {
    return $this->backupRules;
  }
  /**
   * @param string
   */
  public function setBackupVault($backupVault)
  {
    $this->backupVault = $backupVault;
  }
  /**
   * @return string
   */
  public function getBackupVault()
  {
    return $this->backupVault;
  }
  /**
   * @param string
   */
  public function setBackupVaultServiceAccount($backupVaultServiceAccount)
  {
    $this->backupVaultServiceAccount = $backupVaultServiceAccount;
  }
  /**
   * @return string
   */
  public function getBackupVaultServiceAccount()
  {
    return $this->backupVaultServiceAccount;
  }
  /**
   * @param string
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * @param string
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * @param string
   */
  public function setEtag($etag)
  {
    $this->etag = $etag;
  }
  /**
   * @return string
   */
  public function getEtag()
  {
    return $this->etag;
  }
  /**
   * @param string[]
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * @param string
   */
  public function setLogRetentionDays($logRetentionDays)
  {
    $this->logRetentionDays = $logRetentionDays;
  }
  /**
   * @return string
   */
  public function getLogRetentionDays()
  {
    return $this->logRetentionDays;
  }
  /**
   * @param string
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param string
   */
  public function setResourceType($resourceType)
  {
    $this->resourceType = $resourceType;
  }
  /**
   * @return string
   */
  public function getResourceType()
  {
    return $this->resourceType;
  }
  /**
   * @param string
   */
  public function setRevisionId($revisionId)
  {
    $this->revisionId = $revisionId;
  }
  /**
   * @return string
   */
  public function getRevisionId()
  {
    return $this->revisionId;
  }
  /**
   * @param string
   */
  public function setRevisionName($revisionName)
  {
    $this->revisionName = $revisionName;
  }
  /**
   * @return string
   */
  public function getRevisionName()
  {
    return $this->revisionName;
  }
  /**
   * @param string
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return string
   */
  public function getState()
  {
    return $this->state;
  }
  /**
   * @param string[]
   */
  public function setSupportedResourceTypes($supportedResourceTypes)
  {
    $this->supportedResourceTypes = $supportedResourceTypes;
  }
  /**
   * @return string[]
   */
  public function getSupportedResourceTypes()
  {
    return $this->supportedResourceTypes;
  }
  /**
   * @param string
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(BackupPlan::class, 'Google_Service_Backupdr_BackupPlan');
